'******************************************************************************
' IP declarations
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile
$lib "tcpip.lbx"                                            'we need it for the checksum calculation

'******************************************************************************
' Constants and Variables
'******************************************************************************
'the frame-length
#if _chip = 23
    Const Max_framelen = 700
#endif
#if _chip = 37
    Const Max_framelen = 1306
#endif
#if _chip = 59
    Const Max_framelen = 1306
#endif
#if _chip = 103
    Const Max_framelen = 1506
#endif

    Const Frame_size = 54
    Const Maxload = Max_framelen - Frame_size

Dim Buffer(max_framelen) As Byte
Dim Buffer_start As Byte At Buffer Overlay


Const Eth_headerlength = 14
Const Eth_w_packettype_arp = &H0608                         'reversed 0806 = ARP
Const Eth_w_packettype_ip = &H0008                          'reversed 0800 = IP

Const Ip_standard_vers_and_length = &H45
Const Ip_headerlength = 20
Const Ip_broadcast = &HFFFFFFFF
Const Ip_protocol_icmp = 1
Const Ip_protocol_udp = 17
Const Ip_protocol_tcp = 6
Const Ip_protocol_http = 80

Dim Ip_target_addr(4) As Byte
Dim Eth_target_addr(6) As Byte

'******************************************************************************
' Ethernet Frame
'******************************************************************************
Dim Eth_b_dest_mac(6) As Byte At Buffer(1) Overlay
Dim Eth_b_src_mac(6) As Byte At Buffer(7) Overlay
Dim Eth_w_packettype As Word At Buffer(13) Overlay

'******************************************************************************
' IP Frame
'******************************************************************************
Dim Ip_header_start As Byte At Buffer(15) Overlay
Dim Ip_b_vers_and_length As Byte At Buffer(15) Overlay
Dim Ip_b_type_of_service As Byte At Buffer(16) Overlay
Dim Ip_w_packet_length As Word At Buffer(17) Overlay
Dim Ip_w_identifier As Word At Buffer(19) Overlay
Dim Ip_w_fragmentation As Word At Buffer(21) Overlay
Dim Ip_b_time_to_live As Byte At Buffer(23) Overlay
Dim Ip_b_protocol As Byte At Buffer(24) Overlay
Dim Ip_w_hdr_cksum As Word At Buffer(25) Overlay
Dim Ip_b_srcaddr(4) As Byte At Buffer(27) Overlay
Dim Ip_b_srcaddr_l As Long At Ip_b_srcaddr(1) Overlay
Dim Ip_b_destaddr(4) As Byte At Buffer(31) Overlay
Dim Ip_b_destaddr_l As Long At Ip_b_destaddr(1) Overlay

'******************************************************************************
' Subroutines
'******************************************************************************
Declare Sub Handle_enc28j60packet
Declare Sub Ip_set_packet_length(byval Packlength As Word)
Declare Function Ip_get_packet_length() As Word
Declare Sub Ip_header_checksum
Declare Function Ip_get_next_identifier() As Word
Declare Function Ip_target_is_on_my_subnet(ip_addr As Byte) As Byte
Declare Function Get_mac_for_ip(ip_addr As Byte , Mac_addr As Byte) As Byte
#if Debug_ip > 0
   Declare Sub Dump_buffer(t_buffer As Byte , Byval Count As Word)
   Declare Sub Eth_dump_header
   Declare Sub Ip_dump_header
#endif
Declare Sub Clear_buffer
Declare Function Reversed_long(byval Lg As Long) As Long
Declare Function Is_equal_ip(ip1 As Byte , Ip2 As Byte) As Byte
Declare Function Ip_packet_is_for_me() As Byte